/* this is a wrapper around the lp unified program that implements the multiple imputation procedure and returns the relevant statistics */
program mi_lp_drinking_unified_prog, rclass
	set more off

	/*	
		`1' is aggregation level
		`2' is earliest year
		`3' is latest year
		`4' is the first hour
		`5' is the last hour
		`6' is equal mixing
		`7' is the drinking definition
		`8' is the threshold for tossing state-year observations because of missing data (LP state they do this, but the threshold is unclear)
		`9' is the BAC threshold below which positive values are set to missing
	*/
	
	local mi_num = 10 /* number of multiple imputations to use...default to all 10 */
	local agg_level = "`1'"
	
	capture log close
	log using "unified LP output\mi_lp_`1'_`2'_`3'_`4'_`5'_`6'_`7'_`8'_`9'_`mi_num'.smcl", replace

	display "Method:  `1'"
	display "Years: `2' - `3'"
	display "Hours:  `4'"
	display "Equal Mixing Assumed:  `6'"
	display "Drinking definition:  `7'"
	display "Missing threshold:  `8'"

	log off
	
	matrix theta_mi = J(1,`mi_num',.)
	local theta_mi_hat = 0
	matrix theta_se_mi = J(1,`mi_num',.)
	local theta_se_mi_hat = 0
	matrix lambda_mi = J(1,`mi_num',.)
	local lambda_mi_hat = 0
	matrix lambda_se_mi = J(1,`mi_num',.)
	local lambda_se_mi_hat = 0
	matrix N_mi = J(1,`mi_num',.)
	local N_mi_hat = 0
	matrix N_se_mi = J(1,`mi_num',.)
	local N_se_mi_hat = 0
	local df_mi_hat = 0
	local ll_mi_hat = 0
	/* first run to do multiple imputation and calculate means of estimates */
	forvalues i = 1/`mi_num' { /* multiple imputation using the BAC primary definition */
		lp_drinking_unified_prog `agg_level' `2' `3' `4' `5' `6' `7' `8' `9' `i'
		matrix theta_mi[1,`i'] = `r(theta)' /* need to store these in matrix for later SE calculation */
		matrix theta_se_mi[1,`i'] = `r(theta_se)' /* need to store these in matrix for later SE calculation */
		local theta_mi_hat = `theta_mi_hat' + theta_mi[1,`i']/`mi_num'	
		matrix lambda_mi[1,`i'] = `r(lambda)' /* need to store these in matrix for later SE calculation */
		matrix lambda_se_mi[1,`i'] = `r(lambda_se)' /* need to store these in matrix for later SE calculation */
		local lambda_mi_hat = `lambda_mi_hat' + lambda_mi[1,`i']/`mi_num'
		matrix N_mi[1,`i'] = `r(N)' /* need to store these in matrix for later SE calculation */
		matrix N_se_mi[1,`i'] = `r(N_se)' /* need to store these in matrix for later SE calculation */
		local N_mi_hat = `N_mi_hat' + N_mi[1,`i']/`mi_num'
		local df_mi_hat = `df_mi_hat' + `r(df)'/`mi_num'
		local ll_mi_hat = `ll_mi_hat' + `r(ll)'/`mi_num'
	}
	/* need to do a second loop to calculate standard errors */
	forvalues i = 1/`mi_num' { 
		local theta_se_mi_hat = `theta_se_mi_hat' + theta_se_mi[1,`i']^2/`mi_num' + (1 + 1/`mi_num')/(`mi_num'-1)*(theta_mi[1,`mi_num']-`theta_mi_hat')^2
		local lambda_se_mi_hat = `lambda_se_mi_hat' + lambda_se_mi[1,`i']^2/`mi_num' + (1 + 1/`mi_num')/(`mi_num'-1)*(lambda_mi[1,`mi_num']-`lambda_mi_hat')^2
		local N_se_mi_hat = `N_se_mi_hat' + N_se_mi[1,`i']^2/`mi_num' + (1 + 1/`mi_num')/(`mi_num'-1)*(N_mi[1,`mi_num']-`N_mi_hat')^2
	}
	local theta_se_mi_hat = `theta_se_mi_hat'^0.5
	local lambda_se_mi_hat = `lambda_se_mi_hat'^0.5
	local N_se_mi_hat = `N_se_mi_hat'^0.5
	
	log using "unified LP output\mi_lp_`1'_`2'_`3'_`4'_`5'_`6'_`7'_`8'_`9'_`mi_num'.smcl", replace
	disp "****Copy and pasteable mean and standard error estimates: "
	disp "(Theta, Theta SE, Lambda, Lambda SE, N, N SE, Degrees of freedom, Log likelihood): `theta_mi_hat',`theta_se_mi_hat',`lambda_mi_hat',`lambda_se_mi_hat',`N_mi_hat',`N_se_mi_hat',`df_mi_hat',`ll_mi_hat'"
	log close
	
	* return the estimated parameters for programmatic use
	return scalar theta = `theta_mi_hat'
	return scalar theta_se = `theta_se_mi_hat'
	return scalar lambda = `lambda_mi_hat'
	return scalar lambda_se = `lambda_se_mi_hat'
	return scalar N = `N_mi_hat'
	return scalar N_se = `N_se_mi_hat'
	return scalar df = `df_mi_hat'
	return scalar ll = `ll_mi_hat'
end
